/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SerializerFactory;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQResultItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullToStax;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQItemType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQItem
implements XQResultItem {
    private Item item;
    private Configuration config;
    SaxonXQDataFactory dataFactory;

    public SaxonXQItem(Item item, SaxonXQDataFactory factory) {
        this.item = item;
        this.dataFactory = factory;
        this.config = factory.getConfiguration();
    }

    Configuration getConfiguration() {
        return this.config;
    }

    Item getItem() {
        return this.item;
    }

    public XQConnection getConnection() throws XQException {
        if (this.dataFactory instanceof XQConnection) {
            return (XQConnection)((Object)this.dataFactory);
        }
        return null;
    }

    public void close() {
        this.item = null;
    }

    public boolean isClosed() {
        return this.item == null;
    }

    public String getAtomicValue() throws XQException {
        if (this.item instanceof AtomicValue) {
            return this.item.getStringValue();
        }
        throw new XQException("Failed to getAtomicValue: item is a node, or is closed");
    }

    public boolean getBoolean() throws XQException {
        if (this.item instanceof BooleanValue) {
            return ((BooleanValue)this.item).getBooleanValue();
        }
        throw new XQException("Failed in getBoolean: item is not a boolean, or is closed");
    }

    public byte getByte() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (byte)SaxonXQItem.longValue(prim, -128L, 127L);
        }
        throw new XQException("Failed in getByte: item is not an atomic value, or is closed");
    }

    private static long longValue(AtomicValue value, long min, long max) throws XQException {
        if (value instanceof NumericValue) {
            if (value instanceof DoubleValue || value instanceof FloatValue) {
                throw new XQException("Value is a double or float");
            }
            if (!((NumericValue)value).isWholeNumber()) {
                throw new XQException("Value is not a whole number");
            }
            try {
                long val = ((NumericValue)value).longValue();
                if (val >= min && val <= max) {
                    return val;
                }
                throw new XQException("Value is out of range for requested type");
            }
            catch (XPathException err) {
                XQException xqe = new XQException(err.getMessage());
                xqe.initCause(err);
                throw xqe;
            }
        }
        throw new XQException("Value is not numeric");
    }

    public double getDouble() throws XQException {
        if (this.item instanceof DoubleValue) {
            return ((DoubleValue)this.item).getDoubleValue();
        }
        throw new XQException("Failed in getDouble: item is not a double, or is closed");
    }

    public float getFloat() throws XQException {
        if (this.item instanceof FloatValue) {
            return ((FloatValue)this.item).getFloatValue();
        }
        throw new XQException("Failed in getFloat: item is not a float, or is closed");
    }

    public int getInt() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (byte)SaxonXQItem.longValue(prim, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        throw new XQException("Failed in getInt: item is not an atomic value, or is closed");
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return new PullToStax((PullProvider)new PullFromIterator((SequenceIterator)SingletonIterator.makeIterator((Item)this.item)));
    }

    public String getItemAsString(Properties props) throws XQException {
        if (props == null) {
            props = new Properties();
            props.setProperty("method", "xml");
            props.setProperty("indent", "yes");
            props.setProperty("omit-xml-declaration", "yes");
        }
        StringWriter writer = new StringWriter();
        this.writeItem(writer, props);
        return writer.toString();
    }

    public XQItemType getItemType() throws XQException {
        if (this.item instanceof AtomicValue) {
            return new SaxonXQItemType(((AtomicValue)this.item).getItemType(this.getConfiguration().getTypeHierarchy()), this.getConfiguration());
        }
        return new SaxonXQItemType((NodeInfo)this.item);
    }

    public long getLong() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (byte)SaxonXQItem.longValue(prim, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        throw new XQException("Failed in getLong: item is not an atomic value, or is closed");
    }

    public Node getNode() throws XQException {
        if (!(this.item instanceof NodeInfo)) {
            throw new XQException("Failed in getNode: item is an atomic value, or is closed");
        }
        return NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)this.item));
    }

    public URI getNodeUri() throws XQException {
        if (this.item instanceof NodeInfo) {
            try {
                return new URI(((NodeInfo)this.item).getSystemId());
            }
            catch (URISyntaxException e) {
                throw new XQException("System ID of node is not a valid URI");
            }
        }
        throw new XQException("Item is not a node, or is closed");
    }

    public Object getObject() throws XQException {
        return this.dataFactory.getObjectConverter().toObject(this);
    }

    public short getShort() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue prim = (AtomicValue)this.item;
            return (byte)SaxonXQItem.longValue(prim, -32768L, 32767L);
        }
        throw new XQException("Failed in getShort: item is not an atomic value, or is closed");
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        return ((SaxonXQItemType)type).getSaxonItemType().matchesItem(this.item, false, this.config);
    }

    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.writeItemToResult(new StreamResult(os), props);
    }

    public void writeItem(Writer ow, Properties props) throws XQException {
        this.writeItemToResult(new StreamResult(ow), props);
    }

    public void writeItemToResult(Result result) throws XQException {
        this.writeItemToResult(result, new Properties());
    }

    private void writeItemToResult(Result result, Properties props) throws XQException {
        try {
            SerializerFactory sf = this.config.getSerializerFactory();
            PipelineConfiguration pipe = this.config.makePipelineConfiguration();
            Receiver out = sf.getReceiver(result, pipe, props);
            TreeReceiver tr = new TreeReceiver(out);
            tr.open();
            tr.append(this.item, 0, 0);
            tr.close();
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.writeItemToResult(new SAXResult(saxHandler));
    }
}

