xquery version "1.0";

import module namespace saxonb = "http://cefn.com/saxonb/" at "../lib/libout.xquery";
declare namespace c="http://cefn.com/";
declare default element namespace "http://www.w3.org/1999/xhtml";

declare function c:writepage($href, $content, $menu){
    saxonb:write-html($href,
        <html>
        	<head>
        		<link rel="stylesheet" href="assets/style.css" type="text/css"/>
        	</head>
        	<body>
        		<div class="content">
        			<h1>
        				<a href="page_rationale.html"><span class="mute">wi</span><span class="bright">doh</span></a>
        			</h1>
        			<ul class="menu">
        				<li>
        					<a href="list_persons.html">People</a>
        				</li>
        				<li>
        					<a href="list_projects.html">Projects</a>
        				</li>
        				<li>
        					<a href="page_rationale.html">Rationale</a>
        				</li>
        				<li>
        					<a href="page_index.html">About</a>
        				</li>
        			</ul>
        			<div class="page">
        			    {$content}
        			</div>
        			<div class="menu">
        			    {$menu}
        			</div>
        			<div class="footer">
        				CSS copyright: © 2008, Cefn Hoile, inspired by Adam Particka's orangray.      
        			</div>
        		</div>
        	</body>
        </html>
    )
};

declare function c:writelabel($node){
        <div>
            {if($node/@title) then (<h2>{string($node/@title)}</h2>) else ()}
            {if($node/@desc) then (<p>{string($node/@desc)}</p>) else ()}
        </div>
};

declare function c:href($node as item()) as xs:string{
    concat(local-name($node), '_', $node/@id, '.html')
};

declare function c:writelist($nodes){
    for $node in $nodes order by $node/@title return <p><a href="{c:href($node)}">{string($node/@title)}</a></p>
};

let $source := doc('data.xml'),
    $allpages := $source//page,
    $allpersons := $source//person,
    $allprojects := $source//project,
    $defaultmenu := <div><h2>What I Did On Holiday</h2><p>A collection of technology projects undertaken by BT employees in their spare time</p></div>,
    $peoplemenu := <div><h2>Widoh People</h2><p>Anyone is welcome to present, so long as they have a technology project which they've undertaken in their spare time.</p></div>,
    $projectmenu := <div><h2>Widoh Projects</h2><p>Whatever the technology project, the more playful the better. No business cases required.</p></div>
return (
    for $page in $allpages return c:writepage(c:href($page),$page/div[*], $defaultmenu) ,
    for $person in $allpersons order by $person/@title return c:writepage(c:href($person),(c:writelabel($person), <div><h2>Projects</h2>{c:writelist($allprojects[contributor/@refid=$person/@id])}</div>, $person/div[*]), $peoplemenu),
    for $project in $allprojects return c:writepage(c:href($project),(c:writelabel($project), <div><h2>Contributors</h2>{c:writelist($allpersons[@id=$project/contributor/@refid])}</div>,$project/div[*]), $projectmenu),
    c:writepage('list_persons.html', <div>{c:writelist($allpersons)}</div>, $peoplemenu),
    c:writepage('list_projects.html', (for $date in distinct-values($allprojects/@presented) order by xs:date($date) descending return <div><h2>{string($date)}</h2><p>{c:writelist($allprojects[@presented=$date])}</p></div>), $projectmenu)
)