import processing.video.*;

String username = "User"; //change this to your authentication credentials
String gadgetkey = "43500229d89e0263d3ca101e2998ce05ffe8b929"; //change this to your authentication credentials
String gadgetsecret = "3761e64df1036efa97c4c3bc856dfa0059478b18"; //change this to your authentication credentials

int stage = 0;

String[] results = new String[NUMSTAGES];

SymbolSet[] valid = new SymbolSet[NUMSTAGES];

long cursortoggled = 0;
long cursorperiod = 300;
boolean cursorvisible = false;

String lastpattern;
long patternchanged;
long patternperiod = 400;
long patternrepeat = 1000;

color[] colors ;
Area[] areas; 

//temporary graphics 
PFont  genericfont = createFont("HelveticaNeue", 16);
PFont  keyfont = createFont("HelveticaNeue-Bold", 18);
PFont  dialfont = createFont("HelveticaNeue", 48);
PFont  carrierfont = createFont("HelveticaNeue", 8);
PFont  clockfont = createFont("HelveticaNeue", 14);
PFont  numbersfont = createFont("HelveticaNeue", 20);
PFont  matchfont = createFont("HelveticaNeue", 72);

PImage iphoneimg;

int scalewidth, scaleheight;

int credits = 95;

//drawable surface from 21,85 - 237,405 == 216 wide * 320 high
int iphoneminx = 20, iphoneminy = 85, iphonemaxx = 236, iphonemaxy= 405;
int iphonewidth = iphonemaxx - iphoneminx, iphoneheight = iphonemaxy - iphoneminy;
int barheight = 20;

int videooffsetx = 280;
int videooffsety = 80;


//global color variables for key drawing
color keyfillcolor, keyedgecolor, keytextcolor;

int videowidth = 320;
int videoheight = 240;
float numpixels = videowidth * videoheight;
float inverse_pixels = 1.0/numpixels;
Capture camera;
PImage mirror;

java.util.List splashes = new ArrayList();

Symbol lastsymbol = null;
Symbol outputsymbol = null;
long symbolchanged;
long symbolperiod = 400;
long symbolrepeat = 2000;
int[] selection;

long launchtime = System.currentTimeMillis();
Symbol symbolfound = null;

void setup(){
  size(640,480);
  frameRate(5);
  createFullScreenKeyBindings();
  setResolution(640, 480);
  //setFullScreen( true);

  setupVision();
  setupSymbols();
  setupIphone();

  //postSMS("+16177924525", "processingsendsuccessfu");

  //addSplash(new SymbolSplash(LETTERS.symbolWithOutput("a")));

}

void setupVision(){

  colorMode(HSB, 1.0);
  camera = new Capture(this, videowidth, videoheight, 5);
  try{
    mirror = (PImage)camera.clone();
  }
  catch(CloneNotSupportedException cnse){
    System.out.println("Cannot clone camera image");
    System.exit(-1);
  }

  colors = new color[]{
    color(0,0.9,0.9, 0.5),color(0.2,0.9,0.9, 0.5),color(0.4,0.9,0.9, 0.5),color(0.6,0.9,0.9, 0.5),color(0.8,0.9,0.9, 0.5)          };

  areas = new Area[]{
    new Area(0, 0, 220, 160),
    new Area(220, 0, 420, 160),
    new Area(420, 0, 640, 160),

    new Area(0, 160, 220, 320),
    new Area(220, 160, 420, 320),
    new Area(420, 160, 640, 320),

    new Area(0, 320, 220, 480),
    new Area(220, 320, 420, 480),
    new Area(420, 320, 640, 480)
    };

    selection = new int[areas.length];

  colorMode(RGB, 255);

}

void setupIphone(){
  iphoneimg = loadImage("iphone.jpg");
  scaleheight = 480;
  scalewidth =  (int)(386f * 480f / 724f ); //scale to fit in space
}

void setupSymbols(){

  //ADDRESSING
  valid[TO] = new SymbolSet();
  valid[TO].addSymbolSet(NUMBERS);
  valid[TO].addSymbol(NEXT);
  valid[TO].addSymbol(CANCEL);

  //SPECIFYING SENDER
  valid[FROM] = new SymbolSet();
  valid[FROM].addSymbolSet(LETTERS);
  valid[FROM].addSymbol(NEXT);
  valid[FROM].addSymbol(PREV);

  //ENTERING SUBJECT LINE
  valid[SUBJECT] = new SymbolSet();
  valid[SUBJECT].addSymbolSet(LETTERS);
  valid[SUBJECT].addSymbol(NEXT);
  valid[SUBJECT].addSymbol(PREV);

  //POPULATING MESSAGE
  valid[BODY] = new SymbolSet();
  valid[BODY].addSymbolSet(LETTERS);
  valid[BODY].addSymbol(NEXT);
  valid[BODY].addSymbol(SEND);

  //STAGES WITHOUT INPUT
  valid[SENDING] = valid[SENT] = SymbolSet.NONE;

}

void draw(){
  symbolfound = null;

  background(0);

  //draw the video overlay (also checks video colors)
  drawVideo();

  checkPattern();

  //flash cursor
  if((System.currentTimeMillis() - cursortoggled) > cursorperiod){
    cursorvisible = !cursorvisible;
    cursortoggled = System.currentTimeMillis();
  }

  //draw overlays
  if(stage == TO){
    drawIphone();
    drawBar();  
    drawDialPad();
  }
  else if(stage < SENDING){
    drawIphone();
    drawBar();  
    drawKeyPad();

    for(int i = 0; i < SENDING; i++){
      drawHeader(i);    
    }

  }
  else if(stage == SENDING){
    drawIphone();
    fill(255);
    text(headers[SENDING], width/2, height/2);
  }
  else if(stage == SENT){
    drawIphone();
    background(0);
    fill(255);
    text(headers[SENT], width/2, height/2);
  }

  drawSplashes();
  
  if(symbolfound != null){
      addSplash(new SymbolSplash(symbolfound));
      saveFrame(launchtime + "_####.png");
  }
}

void drawSplashes(){
  Iterator siter = splashes.iterator();
  while(siter.hasNext()){
    Splash s = (Splash)siter.next();
    if(s.live()){
      s.draw();
    }
    else{
      siter.remove();
    }
  }
}

void drawBar(){

  int barminx = iphoneminx + 5 , barminy = iphoneminy + 12, barmaxx = iphoneminx + 25, barmaxy = iphoneminy + 2; 

  //draw background
  color barback;
  if(stage == TO){
    barback = color(0);
  }
  else{
    barback = color(0, 0, 0, 20);
  }
  stroke(barback);
  fill(barback);
  rect(iphoneminx, iphoneminy, iphonewidth, barheight);

  //draw bars
  color barcolor = color(0, 0, 200); //for wireless bars
  stroke(barcolor);
  strokeWeight(2);
  for(int i = 0; i < 5; i++){
    int x = iphoneminx + ((barmaxx - barminx) * i / 5);
    int h = (barmaxy - barminy) * i / 5;
    line(x, barminy, x, barminy + h);
  }

  //draw carrier text
  color carriercolor = color(140); //for carrier name
  fill(carriercolor);
  textFont(carrierfont);
  text("CEFN.COM", iphoneminx + 20, barminy + textDescent());

  //draw carrier text
  fill(carriercolor);
  textFont(carrierfont);
  text(credits + " credits left", iphoneminx + 150, barminy + textDescent());

  //draw time of day
  color clockcolor;
  if(stage == TO){
    clockcolor = color(255);
  }
  else{
    clockcolor = color(0);
  }
  fill(clockcolor);
  textFont(clockfont);
  SimpleDateFormat dateformat = new SimpleDateFormat("h:mm a");
  text(dateformat.format(new Date()), iphoneminx + 80, barminy + textDescent());

}

void drawIphone(){
  image(iphoneimg, 0, 0, scalewidth, scaleheight);
}

void drawDialPad(){

  //set globals for keys
  keyfont = genericfont;
  keyedgecolor = color(255);
  keyfillcolor = color(0);
  keytextcolor = color(255);

  int numbersheight = 25;
  color numbersbackcolor = color(35, 57, 71);
  stroke(numbersbackcolor);
  fill(numbersbackcolor);
  rect(iphoneminx, iphoneminy + barheight, iphonewidth, numbersheight);
  textFont(numbersfont);
  stroke(255);
  fill(255);
  if(results[TO] != null){
    text(results[TO], iphoneminx + 20, iphoneminy + barheight + numbersheight - textDescent());
  }

  int keyheight = (iphoneheight - barheight + numbersheight )/ 5;
  int keywidth = iphonewidth / 3;
  for(int rowidx = 0; rowidx < 4; rowidx ++){
    int rowy = iphoneminy + barheight + numbersheight + (keyheight * rowidx);

    if(rowidx < 3){ //main keys drawn here
      for(int keyidx = 0; keyidx < 3; keyidx ++){
        int keyx = iphoneminx + (keyidx * keywidth);
        int number = (rowidx * 3) + keyidx + 1;
        Symbol symbol = valid[stage].symbolWithOutput(new Integer(number).toString());
        drawKey(symbol, keyx, rowy, keywidth, keyheight);
      }
    }
    else{ //special routine for last row
      int keyidx;
      int keyx;
      //cancel
      keyidx = 0;
      keyx = iphoneminx + (keyidx * keywidth);
      drawKey(CANCEL, keyx, rowy, keywidth, keyheight);
      //zero
      keyidx = 1;
      keyx = iphoneminx + (keyidx * keywidth);
      drawKey(NUMBERS.symbolWithOutput("0"), keyx, rowy, keywidth, keyheight);
      //next
      keyidx = 2;
      keyx = iphoneminx + (keyidx * keywidth);
      drawKey(NEXT, keyx, rowy, keywidth, keyheight);

    }
  }


}

void drawKeyPad(){
  //draw background image

  //set globals for keys
  keyfont = genericfont;
  keyedgecolor = color(30);
  keyfillcolor = color(255);
  keytextcolor = color(0);

  //set dimensions
  int keywidth = 20;
  int keyheight = 32;
  int keyspacex = 2;
  int keyspacey = 10;
  int keyrad = 12;
  int keyminy = iphoneminy + 160;

  //fill with white
  stroke(255);
  fill(255);
  rect(iphoneminx, iphoneminy, iphonewidth, iphoneheight);

  //fill keypad with grey
  color keybackcolor = color(139,146,165);
  stroke(keybackcolor);
  fill(keybackcolor);
  rect(iphoneminx, keyminy - keyspacey, iphonewidth, (4 * keyheight) + (5 * keyspacey));

  for(int rowidx = 0; rowidx < rows.length; rowidx++){
    int rowx = iphoneminx + (iphonewidth - (rows[rowidx].length * (keywidth + keyspacex))) / 2;
    int rowy = (rowidx * (keyheight + keyspacey)) + keyminy;
    for(int keyidx = 0; keyidx < rows[rowidx].length; keyidx++){
      String keystring = rows[rowidx][keyidx];
      int keyx = (keyidx * (keywidth + keyspacex)) + rowx;
      Symbol symbol = valid[stage].symbolWithOutput(keystring);
      if(symbol != null){
        drawKey(symbol, keyx, rowy, keywidth, keyheight); 
      }
      else{
        System.err.println("Could not find symbol for " + keystring);
      }
    }
  }  

  int spacebarwidth = (5 * keywidth) + (4 * keyspacex);
  int spacebarheight = keyheight;  
  int spacebarx = iphoneminx + ((iphonewidth - spacebarwidth) / 2);
  int spacebary = keyminy + (3 * (keyheight + keyspacey)); 

  int rowidx = 3;
  int rowy = (rowidx * (keyheight + keyspacey)) + keyminy;

  drawKey(CANCEL, 30, rowy, 40, keyheight);
  drawKey(LETTERS.symbolWithOutput(" "), 80, rowy, 80, keyheight);
  drawKey(NEXT, 180, rowy, 40, keyheight);

}

void drawKey(Symbol symbol, int x, int y, int w, int h){
  strokeWeight(0);

  //draw key itself
  stroke(keyedgecolor);
  fill(keyfillcolor);
  roundedRect(x, y, w, h, 12);

  //draw semaphore highlighting
  colorMode(HSB, 1.0);
  float tilewidth = w / 3.0;
  float tileheight = h / 3.0;
  for(int ytile = 0; ytile < 3; ytile++){
    for(int xtile = 0; xtile < 3; xtile++){

      int shadeidx = symbol.pattern[(ytile * 3) + xtile];
      if(shadeidx != -1){
        color shade = colors[shadeidx];
        strokeWeight(0);
        stroke(0);
        fill(shade);
        ellipse(x + ((xtile + 0.5) * tilewidth), y + ((ytile + 0.5) * tileheight), tilewidth, tileheight);
      }
    }
  }
  colorMode(RGB, 255);

  //draw text
  textFont(keyfont);
  stroke(keytextcolor);
  String keytext = symbol.output;
  if(Character.isLetter(keytext.charAt(0))){
    keytext = keytext.toUpperCase();
  }
  if(keytext.equals(" ")){
    keytext = "space";
  }
  
  stroke(keytextcolor);
  fill(keytextcolor);
  text(keytext, x + ((w - getStringWidth(keytext))/2) , y + h - ((h - textAscent()) /2));

}

int getStringWidth(String keytext){
  int textwidth = 0;
  for(int charpos = 0; charpos < keytext.length(); charpos++){
    textwidth += textWidth(keytext.charAt(charpos)); 
  }
  return textwidth;
}

void drawVideo(){
  colorMode(HSB, 1.0);
  image(mirror, videooffsetx, videooffsety);

  for(int i = 0; i < areas.length; i++){
    areas[i].chooseHue();
    selection[i] = areas[i].chosen;
    if(selection[i] == LEFTFLAG || selection[i] == RIGHTFLAG){
      fill(colors[selection[i]]);
      rect(videooffsetx + areas[i].xmin, videooffsety + areas[i].ymin, areas[i].xmax - areas[i].xmin, areas[i].ymax - areas[i].ymin);
    }
  }
  colorMode(RGB, 255);
}

void drawHeader(int idx){
  float x = iphoneminx;
  float textheight = textDescent() + textAscent();
  float y = iphoneminy + barheight + (idx * 2 * (textheight));
  String display = headers[idx] + (results[idx] != null ? results[idx] : "");
  if(cursorvisible && idx == stage){
    display += "|";
  }
  text(display, x, y);
}

void roundedRect(int x, int y, int w, int h, int r){
  beginShape();
  vertex(x,y+r);
  vertex(x, y+h-r);
  bezierVertex(x, y+h, x, y+h, x + r, y + h);
  vertex(x+w-r, y+h);
  bezierVertex(x+w, y+h, x+w, y+h, x+w, y+h-r);
  vertex(x+w, y+r);
  bezierVertex(x+w, y, x+w, y, x+w-r, y);
  vertex(x + r, y);
  bezierVertex(x, y, x, y, x,y+r);
  endShape(CLOSE);
}

void captureEvent(Capture camera)
{
  camera.read();
  for(int y = 0 ; y < videoheight; y++){
    int startpos, endpos;
    startpos = y * videowidth;
    endpos = startpos + videowidth;
    int posmirror = endpos;
    for(int pos=startpos;pos<endpos;pos++){   
      posmirror--;
      mirror.pixels[posmirror] = camera.pixels[pos]; 
    }
  }
  mirror.updatePixels();

}

void checkPattern(){
  checkKeys();
  checkVideo();
}

void checkVideo(){

  Symbol symbol = valid[stage].symbolWithPattern(selection);

  if(symbol != null && lastsymbol != symbol){
    lastsymbol = symbol;
    symbolchanged = System.currentTimeMillis();
  }

  if(symbol != null){
    fill(color(1.0, 1.0));
    textFont(matchfont);
    System.err.println("Matched symbol : " + symbol.output);

    if(((outputsymbol != symbol) && (System.currentTimeMillis() - symbolchanged > symbolperiod)) ||
      ((outputsymbol == symbol) && (System.currentTimeMillis() - symbolchanged > symbolrepeat))){
      handleSymbol(symbol);
      outputsymbol = symbol;
      lastsymbol = null;
    }     

  }

}

void checkKeys(){
  //fake pattern detection
  String pattern = null;
  if(keyPressed){
    if(keyCode == LEFT){
      if(results[stage] != null && results[stage].length() > 0){
        pattern = "del";
      }
      else{
        pattern = "prev";
      }
    }
    else if(keyCode == RIGHT){
      pattern = "next";
    }
    else{
      pattern = Character.toString(key);
    }
  }
  else{
    pattern = null;
  }

  //handle input
  if(pattern == null){
    if(lastpattern != null){
      lastpattern = null;
      patternchanged = System.currentTimeMillis();
    }
  }
  else{
    if(!pattern.equals(lastpattern)){
      //reset if key changed or key released
      patternchanged = System.currentTimeMillis();
      lastpattern = pattern;
    }
    else if(System.currentTimeMillis() - patternchanged > patternperiod){ //handle only if pattern maintained

        //reset timer
      patternchanged = System.currentTimeMillis();

      //lookup symbol and handle if from valid set
      Symbol selected = valid[stage].symbolWithOutput(pattern);
      if(selected != null){
        handleSymbol(selected);
      }
      else{
        //System.out.println("Match not found for:" + pattern);
        ;
      }
    }

  }

}

void addSplash(Splash s){
  splashes.add(s);
  s.draw();
}

void handleSymbol(Symbol symbol){
  
  symbolfound = symbol;

  if(stage == TO || stage == FROM || stage == SUBJECT || stage == BODY){
    if(symbol == NEXT){
      handleStage(stage + 1);
    }
    else if(symbol == PREV){
      handleStage(stage - 1);
    }
    else if(symbol == SEND){
      handleStage(SENDING);
    }
    else if(symbol == CANCEL){
      results[stage] = results[stage].substring(0, results[stage].length() - 1);
    }
    else{ //append symbol to result (handling null result)
      results[stage] = (results[stage] != null ? results[stage] + symbol.output : symbol.output);
    }
  }

  if(results[stage] == null || results[stage].length() == 0){ //use PREV when zero length
    valid[stage].removeSymbol(CANCEL);
    if(stage > 0){
      valid[stage].addSymbol(PREV);    
    }
  }
  else if(results[stage].length()==1){ //switch to cancel when non zero length
    valid[stage].removeSymbol(PREV);
    valid[stage].addSymbol(CANCEL);
  }

  //handle internationalisation
  if(results[TO] != null && results[TO].length() > 0 && (!results[TO].startsWith("+"))){
    if(results[TO].equals("011")){
      results[TO] = "+";
    }
    else if(results[TO].equals("1")){
      results[TO] = "+1";
    }
    else{
      results[TO] = "+1" + results[TO];
    }
  }
}

void handleStage(int newstage){
  stage = newstage;
  if(stage == SENDING){
    String from = results[FROM] != null ? results[FROM] : "somebody";
    String subject = results[SUBJECT] != null ? "{" + results[SUBJECT] + "} ": "";
    String body = results[BODY] != null ? results[BODY] : "";
    results[SENDING] = from + " flagged " + subject + body + "[sent by cefn.com iPhore]";    
    postSMS(results[TO], results[SENDING]);
    handleStage(stage + 1);
  }
  else if(stage == SENT){
    addSplash(new ScreenSplash("Sent your message"));
    handleStage(stage + 1);
  }
  else if(stage == NUMSTAGES){
    stage = 0;
    results = new String[NUMSTAGES];
  }
}

String postSMS(String telno, String msg){
  String page="";
  try{
    //prepare values
    String messagename = "iphore-" + System.currentTimeMillis();

    //concatenate and SHA1 digest   
    String digestinput = username + ":" + gadgetkey + ":" + messagename + ":" + gadgetsecret;
    byte[] digestinputbytes = digestinput.getBytes("US-ASCII"); 
    byte[] digestoutputbytes = java.security.MessageDigest.getInstance("SHA1").digest(digestinputbytes);
    String digest = "";
    for(int i = 0; i < digestoutputbytes.length; i++){
      digest += Integer.toHexString(digestoutputbytes[i] & 0xFF);
    }
    System.out.println("Digest is:" + digest);

    HttpURLConnection   urlConn;
    DataOutputStream    printout;
    DataInputStream     input;
    urlConn = (HttpURLConnection)new URL("http://mojo.bt.com/messages").openConnection();
    urlConn.setDoInput (true);
    urlConn.setDoOutput (true);
    urlConn.setUseCaches (false);
    urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
    printout = new DataOutputStream (urlConn.getOutputStream ());
    String content =
      "name=" + URLEncoder.encode(messagename) +
      "&recipient=" + URLEncoder.encode (telno) +
      "&text=" + URLEncoder.encode(msg) +
      "&gadgetkey=" + URLEncoder.encode(gadgetkey) + 
      "&username=" + URLEncoder.encode(username) +
      "&digest=" + URLEncoder.encode(digest);
    printout.writeBytes (content);
    printout.flush ();
    printout.close ();
    try{
      input = new DataInputStream (urlConn.getInputStream ());
    }
    catch(IOException ioe){
      input = new DataInputStream(urlConn.getErrorStream());
    }
    String str;
    while (null != ((str = input.readLine())))
    {
      System.err.println (str);
      page+= str;
    }
    input.close ();
  }
  catch(java.security.NoSuchAlgorithmException nsae){
    throw new RuntimeException(nsae);
  }
  catch(UnsupportedEncodingException uee){
    throw new RuntimeException(uee);
  }
  catch(IOException ioe){
    throw new RuntimeException(ioe);
  }

  return page;

}

int maxPos(float[] arr){
  int maxpos = -1;
  float maxval = -Float.MAX_VALUE;
  for(int i = 0; i < arr.length; i++){
    if(arr[i] > maxval){
      maxval = arr[i];
      maxpos = i;
    }
  }
  return maxpos;
}

static abstract class Splash{
  Splash(String msg, long period){
    this.msg = msg;
    this.period = period;
    this.start = System.currentTimeMillis();
  }

  boolean live(){
    return System.currentTimeMillis() - start < period;
  }

  abstract void draw();
  
  String msg;
  long period;
  long start;

}

class ScreenSplash extends Splash{
  ScreenSplash(String msg){
    super(msg, 2000);
  }
  void draw(){
    stroke(color(255));
    fill(color(255));
    rect(iphoneminx, iphoneminy, iphonewidth, iphoneheight);
    stroke(color(0));
    fill(color(0));
    text(msg, iphoneminx + 30, iphoneminy + (iphoneheight / 2));
  }
}

class SymbolSplash extends Splash{

  SymbolSplash(Symbol s){
    super(s.output.toUpperCase(), 3000);
  }

  void draw(){
    textFont(matchfont);
    stroke(255);
    fill(255);
    text(msg, videooffsetx + ((videowidth - getStringWidth(msg)) /2), videooffsety + textDescent() + (videoheight/2));
  }

}


static class Symbol{

  Symbol(char letter, int[] pattern){
    this(Character.toString(letter), pattern);
  }
  Symbol(String output, int[] pattern){
    this.pattern = pattern;
    this.output = output;
  }

  boolean patternMatches(int[] test){
    for(int pos = 0; pos < pattern.length; pos++){
      if(test[pos] != pattern[pos]){
        return false;
      }
    }
    return true;
  }

  String output;
  private int[] pattern;

}

static class SymbolSet {

  private java.util.HashSet contents = new java.util.HashSet();

  SymbolSet(){
    ;
  }
  SymbolSet(Symbol[] toadd){ 
    this.addSymbols(toadd); 
  }

  void addSymbol(Symbol toadd){
    contents.add(toadd);
  }
  void addSymbolSet(SymbolSet toadd){
    contents.addAll(toadd.contents);
  }
  void addSymbols(Symbol[] toadd){
    contents.addAll(Arrays.asList((Symbol[])toadd.clone()));
  }

  void removeSymbol(Symbol toremove){
    contents.remove(toremove);
  }

  Symbol symbolWithPattern(int[] pattern){
    Iterator iter = contents.iterator();
    Symbol match = null;
    while(iter.hasNext() && match == null){
      Symbol next = (Symbol)iter.next();
      if(next.patternMatches(pattern)){
        match = next;
      }
    }
    return match;
  }

  Symbol symbolWithOutput(String test){
    Iterator iter = contents.iterator();
    Symbol match = null;
    while(iter.hasNext() && match == null){
      Symbol next = (Symbol)iter.next();
      if(next.output.equals(test)){
        match = next;
      }
    }
    return match;
  }


  public static final SymbolSet NONE = new SymbolSet();

}

class Area{

  int xmin, ymin, xmax, ymax, chosen;

  float[] av = new float[colors.length]; //the current running average
  int avptr = 0; //the current place in the averaging window
  int avsteps = 50; //steps in running av (10fps * 5 secs);
  int avfull = 0; //buffer entries full
  float[][] avbuf = new float[avsteps][]; //the buffer used to store past values

  Area(int xmin, int ymin, int xmax, int ymax){
    this.xmin = xmin / 2;
    this.ymin = ymin / 2;
    this.xmax = xmax / 2;
    this.ymax = ymax / 2;

    //populate the multi-dimensional level-averaging array 
    for(int i = 0; i < avbuf.length; i++){
      avbuf[i] = new float[colors.length];
    } 

  }

  void chooseHue(){
    //get level and update running average
    float[] levels = countPixels();

    for(int i = 0; i < levels.length; i++){
      av[i] -= avbuf[avptr][i]; //take the oldest value off the running average
      av[i] += levels[i]; //add the newest value to the running average
      avbuf[avptr][i] = levels[i]; //store the newest value in place of the oldest value
      if(avfull > 0){
        levels[i] -= (av[i] / avfull); //normalise the value of this level by subtracting the average
      }
    }

    avptr++; 
    if(avptr == avsteps){
      avptr = 0; //cause the value to wrap around
    }  
    if(avfull < avsteps){
      avfull ++;  
    }

    int bucket = maxPos(levels);
    if(levels[bucket] > 0.0005f){
      this.chosen = bucket;
    }
    else{
      this.chosen = -1;
    }

  }

  float[] countPixels(){
    float[] levels = new float[]{
      0,0,0,0,0            };
    int pos = 0, bucket = 0;
    float hueval = 0; 
    loadPixels();
    try{
      for ( int x = xmin; x < xmax; x++){
        for ( int y = ymin; y < ymax; y++){
          pos = x + (y*mirror.width);
          hueval = hue(mirror.pixels[pos]);
          bucket = ((int)floor((hueval + 0.1) * 5)) % 5;
          levels[bucket] += brightness(mirror.pixels[pos]) * saturation(mirror.pixels[pos]) * saturation(mirror.pixels[pos]) * inverse_pixels;
        }
      }
      return levels;
    }
    catch(RuntimeException e){
      print("Hueval:" + hueval + "Bucket:" + bucket);
      throw e;
    }
  }

}


final static int TO = 0;
final static int FROM = 1;
final static int SUBJECT = 2;
final static int BODY = 3;
final static int SENDING = 4;
final static int SENT = 5;
final static int NUMSTAGES = 6;

final static String[] headers = {
  "To: ",
  "From: ",
  "Subject: ",
  "",
  "Sending your message",
  "Message sent successfully"
};

final static int RIGHTFLAG = 3;
final static int LEFTFLAG = 1;

final static Symbol PREV = new Symbol("prev", new int[]{
  -1, -1, RIGHTFLAG
    -1, -1, -1,
  LEFTFLAG, -1, -1
}
);
final static Symbol NEXT = new Symbol("next", new int[]{
  LEFTFLAG,  RIGHTFLAG,  -1,
  -1, -1, -1,
  -1, -1, -1
}
);
final static Symbol CANCEL = new Symbol("del", new int[]{
  -1, -1,  RIGHTFLAG,
  -1, -1, -1,
  LEFTFLAG, -1, -1
}
);
final static Symbol SEND = new Symbol("send", new int[]{
  -1,  LEFTFLAG,  RIGHTFLAG,
  -1, -1, -1,
  -1, -1, -1
}
);

final static SymbolSet LETTERS = new SymbolSet(new Symbol[]{
  new Symbol('a', new int[]{
    -1, -1, -1,
    -1, -1, -1,
    -1,  LEFTFLAG,  RIGHTFLAG
  }
  ),
  new Symbol('b', new int[]{
    -1, -1, -1,
    -1, -1,  RIGHTFLAG,
    -1,  LEFTFLAG, -1
  }
  ),
  new Symbol('c', new int[]{
    -1, -1,  RIGHTFLAG,
    -1, -1, -1,
    -1,  LEFTFLAG, -1
  }
  ),
  new Symbol('d', new int[]{
    -1,  RIGHTFLAG, -1,
    -1, -1, -1,
    -1,  LEFTFLAG, -1
  }
  ),
  new Symbol('e', new int[]{
    LEFTFLAG, -1, -1,
    -1, -1, -1,
    -1,  RIGHTFLAG, -1
  }
  ),
  new Symbol('f', new int[]{
    -1, -1, -1,
    LEFTFLAG, -1, -1,
    -1,  RIGHTFLAG, -1
  }
  ),
  new Symbol('g', new int[]{
    -1, -1, -1,
    -1, -1, -1,
    LEFTFLAG,  RIGHTFLAG, -1
  }
  ),
  new Symbol('h', new int[]{
    -1, -1, -1,
    -1, -1, LEFTFLAG,
    -1, -1, RIGHTFLAG
  }
  ),
  new Symbol('i', new int[]{
    -1, -1, LEFTFLAG,
    -1, -1, -1,
    -1, -1, RIGHTFLAG
  }
  ),
  new Symbol('j', new int[]{
    -1,  RIGHTFLAG, -1,
    LEFTFLAG, -1, -1,
    -1, -1, -1
  }
  ),
  new Symbol('k', new int[]{
    -1,  LEFTFLAG, -1,
    -1, -1, -1,
    -1, -1,  RIGHTFLAG
  }
  ),
  new Symbol('l', new int[]{
    LEFTFLAG, -1, -1,
    -1, -1, -1,
    -1, -1,  RIGHTFLAG
  }
  ),
  new Symbol('m', new int[]{
    -1, -1, -1,
    LEFTFLAG, -1, -1,
    -1, -1,  RIGHTFLAG
  }
  ),
  new Symbol('n', new int[]{
    -1, -1, -1,
    -1, -1, -1,
    LEFTFLAG, -1,  RIGHTFLAG
  }
  ),
  new Symbol('o', new int[]{
    -1, -1,  LEFTFLAG,
    -1, -1,  RIGHTFLAG,
    -1, -1, -1
  }
  ),
  new Symbol('p', new int[]{
    -1,  LEFTFLAG, -1,
    -1, -1,  RIGHTFLAG,
    -1, -1, -1
  }
  ),
  new Symbol('q', new int[]{
    LEFTFLAG, -1, -1,
    -1, -1,  RIGHTFLAG,
    -1, -1, -1
  }
  ),
  new Symbol('r', new int[]{
    -1, -1, -1,
    LEFTFLAG, -1,  RIGHTFLAG,
    -1, -1, -1
  }
  ),
  new Symbol('s', new int[]{
    -1, -1, -1,
    -1, -1,  RIGHTFLAG,
    LEFTFLAG, -1, -1
  }
  ),
  new Symbol('t', new int[]{
    -1,  LEFTFLAG,  RIGHTFLAG,
    -1, -1, -1,
    -1, -1, -1
  }
  ),
  new Symbol('u', new int[]{
    LEFTFLAG, -1,  RIGHTFLAG,
    -1, -1, -1,
    -1, -1, -1
  }
  ),
  new Symbol('v', new int[]{
    -1,  RIGHTFLAG, -1,
    -1, -1, -1,
    LEFTFLAG, -1, -1
  }
  ),
  new Symbol('w', new int[]{
    RIGHTFLAG, -1, -1,
    LEFTFLAG, -1, -1,
    -1, -1, -1
  }
  ),
  new Symbol('x', new int[]{
    RIGHTFLAG, -1, -1,
    -1, -1, -1,
    LEFTFLAG, -1, -1
  }
  ),
  new Symbol('y', new int[]{
    -1, -1,  RIGHTFLAG,
    LEFTFLAG, -1, -1,
    -1, -1, -1
  }
  ),
  new Symbol('z', new int[]{
    -1, -1, -1,
    RIGHTFLAG, -1, -1,
    LEFTFLAG, -1, -1
  }
  ),
  new Symbol(' ', new int[]{
    -1, -1, -1,
    -1, -1,  -1,
    -1,  RIGHTFLAG,  -1
  }
  )
}
);

final static SymbolSet NUMBERS = new SymbolSet(new Symbol[]{
  new Symbol('1', new int[]{
    -1, -1, -1,
    -1, -1,  -1,
    -1,  LEFTFLAG,  RIGHTFLAG
  }
  ),
  new Symbol('2', new int[]{
    -1, -1, -1,
    -1, -1,  RIGHTFLAG,
    -1,  LEFTFLAG, -1
  }
  ),
  new Symbol('3', new int[]{
    -1, -1,  RIGHTFLAG,
    -1, -1, -1,
    -1,  LEFTFLAG, -1
  }
  ),
  new Symbol('4', new int[]{
    -1,  RIGHTFLAG, -1,
    -1, -1, -1,
    -1,  LEFTFLAG, -1
  }
  ),
  new Symbol('5', new int[]{
    LEFTFLAG, -1, -1,
    -1, -1, -1,
    -1,  RIGHTFLAG, -1
  }
  ),
  new Symbol('6', new int[]{
    -1, -1, -1,
    LEFTFLAG, -1, -1,
    -1,  RIGHTFLAG, -1
  }
  ),
  new Symbol('7', new int[]{
    -1, -1, -1,
    -1, -1, -1,
    LEFTFLAG,  RIGHTFLAG, -1
  }
  ),
  new Symbol('8', new int[]{
    -1, -1, -1,
    LEFTFLAG, -1, -1,
    RIGHTFLAG, -1, -1
  }
  ),
  new Symbol('9', new int[]{
    RIGHTFLAG, -1, -1,
    -1, -1, -1,
    LEFTFLAG, -1, -1
  }
  ),
  new Symbol('0', new int[]{
    -1, -1,  LEFTFLAG,
    -1, -1,  RIGHTFLAG,
    -1, -1, -1
  }
  )
}
);

public static final String[][] rows = {
  new String[]{
    "q", "w", "e", "r", "t", "y", "u", "i", "o", "p"
  }
  ,
  new String[]{
    "a", "s", "d", "f", "g", "h", "j", "k", "l"
  }
  ,
  new String[]{
    "z", "x", "c", "v", "b", "n", "m"
  }
};
