BEGIN {
	print "CREATE DATABASE IF NOT EXISTS anglia;"
	print "USE anglia;"
	print "CREATE TABLE IF NOT EXISTS elevation ( id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, col SMALLINT, row SMALLINT, z SMALLINT);"
	print "CREATE INDEX coord_col_row ON elevation (col,row);"
	print "CREATE INDEX coord_row ON elevation (col);"

	
	latdeg = 52;	
	latmin = 3;
	latsec = 30;
	
	longdeg = 1;
	longmin = 9;
	longsec = 30;
	

	gridoriginlatdeg	= 50;
	gridoriginlongdeg	= 0;
	gridwidth					= 6000;
	gridheight				= 6000;
	gridsearchradius 	= 1000;
	
	centerrow = 6000 - ((((latdeg-gridoriginlatdeg) * 3600) + (latmin * 60) + latsec) / 3);
	centercol = ((((longdeg-gridoriginlongdeg) * 3600) + (longmin * 60) + longsec) / 3);
	lowercol  = centercol - gridsearchradius;
	uppercol  = centercol + gridsearchradius;
	lowerrow  = centerrow - gridsearchradius;
	upperrow  = centerrow + gridsearchradius;

	lineno = 0;

}

/^[-0-9]/{
	if(lineno > lowerrow && lineno < upperrow){
	print "INSERT IGNORE INTO elevation (id,col,row,z) VALUES ";
	for(fieldno=lowercol;fieldno<=NF && fieldno<=uppercol;fieldno++){
		if(match($fieldno, "[0-9]")){
			if($fieldno == -9999){
				$fieldno = "NULL";
			}
			if(fieldno == lowercol){
				sep = ""
			}
			else{
				sep = ","
			}
			print sep "("( (lineno * gridwidth) + fieldno - 1) ", " (fieldno - 1) ", " lineno ", " $fieldno ")"; 
		}
	}
	print ";"
	}
	lineno++;
}

END {
	print "ALTER TABLE elevation";
	for(wind = 45; wind <= 360; wind += 45){
		print "ADD COLUMN `" wind "` TINYINT "
		if(wind != 360){
			print ","
		}
	}
	print ";"

	PI=3.14159265358979;
	for(wind = 45; wind <= 360; wind += 45){
		rad = (wind * 2 * PI) / 360;
		print "UPDATE elevation, elevation AS neighbour SET elevation.`" wind "` = (SELECT elevation.z - neighbour.z) WHERE neighbour.row = elevation.row + " int(cos(rad) * -1.5) " AND neighbour.col = elevation.col + " int(sin(rad) * 1.5) " ;";
		print "SELECT id, `" wind "`, (abs(col-" centercol ") + abs(row - " centerrow ")) as mdist, concat( " gridoriginlongdeg " + (col / 1200), ',', (" gridoriginlatdeg " + ((6000-row) /1200))) as gpsfloat, " wind " as wind from elevation  ORDER BY `" wind "` DESC, mdist ASC LIMIT 1000 into outfile '/tmp/" wind ".txt';";
	}	
}
